/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;

public final class StackUtils {
    private StackUtils() {
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public static List<ItemStack> getMergeRejects(@Nonnull List<IInventorySlot> orig, @Nonnull List<IInventorySlot> toAdd) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack reject;
            IInventorySlot toAddSlot = toAdd.get(i);
            if (toAddSlot.isEmpty() || (reject = StackUtils.getMergeReject(orig.get(i).getStack(), toAddSlot.getStack())).m_41619_()) continue;
            ret.add(reject);
        }
        return ret;
    }

    public static void merge(@Nonnull List<IInventorySlot> orig, @Nonnull List<IInventorySlot> toAdd) {
        for (int i = 0; i < toAdd.size(); ++i) {
            IInventorySlot toAddSlot = toAdd.get(i);
            if (toAddSlot.isEmpty()) continue;
            IInventorySlot origSlot = orig.get(i);
            origSlot.setStack(StackUtils.merge(origSlot.getStack(), toAddSlot.getStack()));
        }
    }

    private static ItemStack merge(ItemStack orig, ItemStack toAdd) {
        if (orig.m_41619_()) {
            return toAdd;
        }
        if (toAdd.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        return StackUtils.size(orig, Math.min(orig.m_41741_(), orig.m_41613_() + toAdd.m_41613_()));
    }

    private static ItemStack getMergeReject(ItemStack orig, ItemStack toAdd) {
        if (orig.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (toAdd.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        int newSize = orig.m_41613_() + toAdd.m_41613_();
        if (newSize > orig.m_41741_()) {
            return StackUtils.size(orig, newSize - orig.m_41741_());
        }
        return StackUtils.size(orig, newSize);
    }

    @Nullable
    public static BlockState getStateForPlacement(ItemStack stack, BlockPos pos, Player player) {
        return Block.m_49814_((Item)stack.m_41720_()).m_5573_(new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, false))));
    }
}

